function NavigationCtrl($scope, $rootScope, StructureJson){

    $scope.pages = StructureJson.getPages();
    $scope.leftPageIndex = StructureJson.getLeftPageIndex();

    $scope.currentPage = ($scope.leftPageIndex !== false) ? $scope.pages[$scope.leftPageIndex] : false;

    if($rootScope.forceOnePage)
    {
        $scope.page = ($scope.currentPage === false) ? '1' : $scope.currentPage['-number'];
    }
    else
    {
        if(StructureJson.isFirstPageSingle())
        {
            $scope.page = '1';
        }
        else
        {
            $scope.page = '1 - 2';
        }
    }

    $scope.$on('Window:resize', function(){
        $scope.setPageValue();
    });

    /**
     * Event pokazujący menu nawigacyjne
     */
    $scope.$on('Navigation:showBar', function(){
        angular.element('.navbar').addClass('active-navbar');
        angular.element('.nav-arrow').css('height', $rootScope.pageMaxHeight);
        $rootScope.navigationBarOpen = true;
    });

    /**
     * Event chowający menu nawigacyjne
     */
    $scope.$on('Navigation:hideBar', function(){
        angular.element('.navbar').removeClass('active-navbar');
        angular.element('.nav-arrow').css('height', 0);
        $rootScope.navigationBarOpen = false;
    });

    /**
     * Dodanie interakcji przerywającej schowanie menu nawigacyjnego
     */
    angular.element('.navbar input').on('focus', function(){
        $rootScope.$broadcast('Navigation:focus');
    });
    angular.element('.navbar li').on('mouseover', function(){
        $rootScope.$broadcast('Navigation:focus');
    });
    angular.element('.nav-arrow').on('mouseover', function(){
        $rootScope.$broadcast('Navigation:focus');
    });

    /**
     * Zmienia numerację stron w zależności od ułożenia strony
     */
    $scope.$on('Page:change', function(e, changeData){
        $scope.page = 0;
        if(changeData.singleView)
        {
            if(changeData.direction == 1)
            {
                $scope.currentPage = StructureJson.getNextPage(changeData.currentPage);
            }
            else
            {
                $scope.currentPage = StructureJson.getPreviousPage(changeData.currentPage);
            }
        }
        else
        {
            if(changeData.direction == 1)
            {
                $scope.currentPage = StructureJson.getNextPage(StructureJson.getNextPage(changeData.currentPage));
            }
            else
            {
                $scope.currentPage = StructureJson.getPreviousPage(StructureJson.getPreviousPage(changeData.currentPage));
            }
        }


        $scope.setPageValue();
        $scope.$apply();
    });


    $scope.$on('Page:jump', function(e, page){
        if(StructureJson.isLeftPage(page) || $rootScope.forceOnePage)
        {
            $scope.currentPage = page;
        }
        else
        {
            $scope.currentPage = StructureJson.getPreviousPage(page);
        }

        $scope.setPageValue();
        $scope.$apply();
    });


    /**
     * Ustawia wartość strony
     */
    $scope.setPageValue = function(){
        if($rootScope.forceOnePage)
        {
            if($scope.currentPage === false)
            {
                $scope.page = '1';
            }
            else
            {
                $scope.page = $scope.currentPage['-number'];
            }
        }
        else
        {
            if(!StructureJson.isFirstPageSingle() && $scope.currentPage === false)
            {
                var leftPage = StructureJson.getNextPage($scope.currentPage);
                var rightPage = StructureJson.getNextPage(leftPage);
            }
            else if(StructureJson.isLeftPage($scope.currentPage))
            {
                var leftPage = $scope.currentPage;
                var rightPage = StructureJson.getNextPage($scope.currentPage);
            }
            else
            {
                var rightPage = $scope.currentPage;
                var leftPage = StructureJson.getPreviousPage(rightPage);
            }

            var page = '';
            if(leftPage !== false)
            {
                page += leftPage['-number'];
            }

            if(rightPage !== false)
            {
                if(page != '')
                {
                    page += ' - ';
                }

                page += rightPage['-number'];
            }

            $scope.page = page;
//
//            $scope.page = ($scope.currentPage !== false) ? $scope.currentPage['-number'] : '';
//            var nextPage = StructureJson.getNextPage($scope.currentPage);
//            if(nextPage)
//            {
//                if($scope.page != '')
//                {
//                    $scope.page += ' - ';
//                }
//                $scope.page += nextPage['-number'];
//            }
        }
    }


    $scope.goToPreviousPage = function(){
        if(!$scope.isFirst())
        {
            $rootScope.$broadcast('Page:beforeChange', {
                direction: -1,
                singleView: ($rootScope.forceOnePage) ? 1 : 0,
                isLeftPage: StructureJson.isLeftPage($scope.currentPage),
                currentPage: $scope.currentPage
            });
        }
    }


    $scope.goToNextPage = function(){
        if(!$scope.isLast())
        {
            if($scope.currentPage === false && (StructureJson.isFirstPageSingle() && $rootScope.forceOnePage))
            {
                $scope.currentPage = StructureJson.getNextPage(false);
            }
            $rootScope.$broadcast('Page:beforeChange', {
                direction: 1,
                singleView: ($rootScope.forceOnePage) ? 1 : 0,
                isLeftPage: StructureJson.isLeftPage($scope.currentPage),
                currentPage: $scope.currentPage
            });
        }
    }



    $scope.goToPageNumber = function(){
        var pageNumber = $scope.page - 1;
        if(pageNumber >= 0 && pageNumber <= $scope.pages.length)
        {
            $rootScope.$broadcast('Page:beforeJump', $scope.pages[pageNumber]);
        }
    }



    $scope.isLast = function(){
        return (StructureJson.isLastPage($scope.currentPage) || (!$rootScope.forceOnePage && StructureJson.isLastPage(StructureJson.getNextPage($scope.currentPage))));
    }

    $scope.isFirst = function(){
        return ($scope.currentPage == false || StructureJson.isFirstPage($scope.currentPage));
    }
}
NavigationCtrl.$inject = ['$scope', '$rootScope', 'StructureJson'];